const axios = require('axios');

async function parseXtreamUrl(url) {
    try {
        const response = await axios.get(url);
        // Processe os dados da resposta conforme necessário
        // Este é um exemplo básico, você precisará ajustar de acordo com a estrutura real da API Xtream
        return {
            categories: response.data.categories || [],
            movies: response.data.movies || [],
            server_info: response.data.server_info || {},
            user_info: response.data.user_info || {}
        };
    } catch (error) {
        console.error('Erro ao analisar URL do Xtream:', error);
        throw error;
    }
}

module.exports = {
    parseXtreamUrl
};