import axios from 'axios';

const instance = axios.create({
  baseURL: 'http://sync.zpainel.site:5000',
  timeout: 30000, // Aumentar o timeout para 30 segundos
});

instance.interceptors.request.use(
  (config) => {
    const token = localStorage.getItem('token');
    if (token) {
      config.headers['Authorization'] = `Bearer ${token}`;
    }
    return config;
  },
  (error) => {
    return Promise.reject(error);
  }
);

instance.interceptors.response.use(
  (response) => response,
  (error) => {
    if (error.response) {
      switch (error.response.status) {
        case 401:
          // Redirecionar para login se não autenticado
          localStorage.clear();
          window.location.href = '/login';
          break;
        case 503:
          console.error('Serviço temporariamente indisponível. Tentando novamente...');
          // Implementar lógica de retry aqui se necessário
          break;
        default:
          console.error('Erro na resposta:', error.response.data);
      }
    } else if (error.request) {
      console.error('Sem resposta recebida:', error.request);
    } else {
      console.error('Erro ao configurar a requisição:', error.message);
    }
    return Promise.reject(error);
  }
);

export default instance;