const fs = require('fs');
const path = require('path');
const { RateLimiter } = require('limiter');

class TMDBKeyManager {
    constructor() {
        const tmdbKeysPath = path.join(__dirname, 'tmdb-keys.json');
        this.apiKeys = JSON.parse(fs.readFileSync(tmdbKeysPath, 'utf8')).keys;
        this.limiters = this.apiKeys.map(() => new RateLimiter({ tokensPerInterval: 4, interval: 'second' }));
        this.keyUsageCounts = new Array(this.apiKeys.length).fill(0);
    }

    async getAvailableKey() {
        const availableKeyIndex = await Promise.race(
            this.limiters.map((limiter, index) => 
                limiter.removeTokens(1)
                    .then(() => {
                        this.keyUsageCounts[index]++;
                        return index;
                    })
                    .catch(() => Promise.reject())
            )
        );

        return this.apiKeys[availableKeyIndex];
    }
}

module.exports = new TMDBKeyManager();
