// routes/series.js
const express = require('express');
const router = express.Router();
const seriesController = require('../controllers/seriesController');
const authMiddleware = require('../middleware/auth');

// Rota para obter bouquets
router.get('/bouquets', authMiddleware, seriesController.getBouquets);

// Rota para obter categorias
router.post('/categories', authMiddleware, seriesController.getCategories);

// Rota para iniciar o processamento de séries
router.post('/process', authMiddleware, seriesController.processSeries);

// Rota para obter o status do processamento
router.get('/process-status', authMiddleware, seriesController.getProcessStatus);

// Rota para pausar o processamento
router.post('/pause', authMiddleware, seriesController.pauseProcess);

// Rota para retomar o processamento
router.post('/resume', authMiddleware, seriesController.resumeProcess);

// Rota para cancelar o processamento
router.post('/cancel', authMiddleware, seriesController.cancelProcess);

module.exports = router;