const express = require('express');
const router = express.Router();
const movieController = require('../controllers/movieController');
const authMiddleware = require('../middleware/auth');

// Apply authMiddleware to all routes
router.use(authMiddleware);

// GET routes
router.get('/bouquets', movieController.getBouquets);
router.get('/process-status', movieController.getProcessStatus);

// POST routes
router.post('/categories', movieController.getCategories);
router.post('/process', movieController.processMovies);
router.post('/pause', movieController.pauseProcess);
router.post('/resume', movieController.resumeProcess);
router.post('/cancel', movieController.cancelProcess);
router.post('/analyze', movieController.analyzeXtreamData);

module.exports = router;