const express = require('express');
const router = express.Router();
const homeController = require('../controllers/homeController');
const authMiddleware = require('../middleware/auth');

router.get('/sync/status', authMiddleware, homeController.getSyncStatus);
router.get('/db/status', authMiddleware, homeController.getDbStatus);
router.get('/user/info', authMiddleware, homeController.getUserInfo);
router.get('/tutorials', authMiddleware, homeController.getTutorials);
router.post('/save-db-credentials', authMiddleware, homeController.saveDbCredentials);

module.exports = router;