const express = require('express');
const router = express.Router();
const autosyncController = require('../controllers/autosynccontroller');
const authMiddleware = require('../middleware/auth');

router.use(authMiddleware);

router.get('/urls', async (req, res, next) => {
  let retries = 3;
  while (retries > 0) {
    try {
      await autosyncController.getUrls(req, res);
      return;
    } catch (error) {
      retries--;
      if (retries === 0) {
        next(error);
      } else {
        console.log(`Retrying... Attempts left: ${retries}`);
        await new Promise(resolve => setTimeout(resolve, 1000)); // Espera 1 segundo antes de tentar novamente
      }
    }
  }
});
router.post('/movies', autosyncController.saveMovieUrl);
router.post('/series', autosyncController.saveSeriesUrl);

module.exports = router;