const express = require('express');
const router = express.Router();
const jwt = require('jsonwebtoken');
const mysql = require('mysql2/promise');

const configDbPool = mysql.createPool({
  host: 'localhost',
  user: 'sync',
  password: '26iaaHCz6mAswTpW',
  database: 'sync',
  connectionLimit: 5
});

router.post('/login', async (req, res) => {
    let connection;
    try {
        const { username, password } = req.body;
        console.log(`Tentativa de login para o usuário: ${username}`);

        connection = await configDbPool.getConnection();
        const [rows] = await connection.execute(
            'SELECT * FROM user_configs WHERE username = ?',
            [username]
        );

        if (rows.length === 0) {
            console.log(`Usuário não encontrado: ${username}`);
            return res.status(401).json({ message: 'Credenciais inválidas' });
        }

        const user = rows[0];

        if (password !== user.password) {
            console.log(`Senha incorreta para o usuário: ${username}`);
            return res.status(401).json({ message: 'Credenciais inválidas' });
        }

        // Verificar se a conta expirou
        if (new Date(user.expirationDate) < new Date()) {
            console.log(`Conta expirada para o usuário: ${username}`);
            return res.status(403).json({ message: 'Sua conta expirou. Por favor, renove sua assinatura.' });
        }

        const token = jwt.sign(
            { username, role: user.role },
            process.env.JWT_SECRET,
            { expiresIn: '1h' }
        );

        console.log(`Login bem-sucedido para o usuário: ${username}`);
        
        res.status(200).json({ 
            token, 
            role: user.role, 
            expiresIn: user.expirationDate,
            username: username
        });
    } catch (error) {
        console.error('Erro durante o login:', error);
        res.status(500).json({ message: 'Erro no servidor' });
    } finally {
        if (connection) {
            connection.release();
        }
    }
});

module.exports = router;