const jwt = require('jsonwebtoken');
const mysql = require('mysql2/promise');

const configDbPool = mysql.createPool({
  host: 'localhost',
  user: 'sync',
  password: '26iaaHCz6mAswTpW',
  database: 'sync',
  connectionLimit: 5
});

const authMiddleware = async (req, res, next) => {
  let connection;
  try {
    console.log('Starting authentication process...');

    let token = null;
    let decodedToken = null;

    // Check for token in Authorization header
    const authHeader = req.headers.authorization;
    if (authHeader && authHeader.startsWith('Bearer ')) {
      token = authHeader.substring(7);
    }

    // If no token in header, check query params
    if (!token) {
      token = req.query.token;
    }

    if (!token) {
      console.log('No token found in request');
      return res.status(401).json({ error: 'Authentication required. Please log in.' });
    }

    try {
      decodedToken = jwt.verify(token, process.env.JWT_SECRET);
    } catch (error) {
      console.error('Token verification failed:', error.message);
      return res.status(401).json({ error: 'Invalid or expired token. Please log in again.' });
    }

    const username = decodedToken.username;

    if (!username) {
      console.log('No username found in token');
      return res.status(401).json({ error: 'Invalid token. Please log in again.' });
    }

    console.log(`Fetching user data for: ${username}`);
    connection = await configDbPool.getConnection();
    const [rows] = await connection.execute(
      'SELECT username, role, expirationDate FROM user_configs WHERE username = ?',
      [username]
    );

    if (rows.length === 0) {
      console.log(`User ${username} not found in database`);
      return res.status(404).json({ error: 'User not found.' });
    }

    const user = rows[0];

    // Check if the account has expired
    if (new Date(user.expirationDate) < new Date()) {
      console.log(`Account for user ${username} has expired`);
      return res.status(403).json({ error: 'Your account has expired. Please renew your subscription.' });
    }

    console.log('User found and account is active, setting req.user');
    req.user = {
      username: user.username,
      role: user.role,
      expiresIn: user.expirationDate
    };

    console.log('Authentication successful');
    next();
  } catch (error) {
    console.error('Authentication error:', error);
    res.status(500).json({ error: 'An error occurred during authentication.' });
  } finally {
    if (connection) {
      connection.release();
    }
  }
};

module.exports = authMiddleware;