const mysql = require('mysql2/promise');

const configDbPool = mysql.createPool({
  host: 'localhost',
  user: 'sync',
  password: '26iaaHCz6mAswTpW',
  database: 'sync',
  connectionLimit: 5
});

exports.getSyncStatus = async (req, res) => {
    res.json({ status: 'online' });
};

exports.getDbStatus = async (req, res) => {
    const { username } = req.user;
    let connection;
    try {
        connection = await configDbPool.getConnection();
        const [rows] = await connection.execute(
            'SELECT dbHost, dbUser, dbPassword FROM user_configs WHERE username = ?',
            [username]
        );

        if (rows.length === 0 || !rows[0].dbHost || !rows[0].dbUser || !rows[0].dbPassword) {
            return res.json({ status: 'offline', isConfigured: false });
        }

        const userDbConnection = await mysql.createConnection({
            host: rows[0].dbHost,
            user: rows[0].dbUser,
            password: rows[0].dbPassword,
            database: 'xui'
        });

        const startTime = Date.now();
        await userDbConnection.query('SELECT 1');
        const endTime = Date.now();
        const responseTime = endTime - startTime;

        await userDbConnection.end();

        res.json({ status: 'online', responseTime, isConfigured: true });
    } catch (error) {
        console.error('Erro ao verificar status do banco de dados:', error);
        res.json({ status: 'offline', isConfigured: true, message: 'Erro ao verificar status do banco de dados' });
    } finally {
        if (connection) connection.release();
    }
};

exports.getUserInfo = async (req, res) => {
    const { username } = req.user;
    let connection;
    try {
        connection = await configDbPool.getConnection();
        const [rows] = await connection.execute(
            'SELECT role, expirationDate FROM user_configs WHERE username = ?',
            [username]
        );

        if (rows.length === 0) {
            return res.status(404).json({ message: 'Usuário não encontrado' });
        }

        const userInfo = rows[0];

        let subscriptionType;
        switch(userInfo.role) {
            case 1:
                subscriptionType = 'Só Filmes';
                break;
            case 2:
                subscriptionType = 'Só Séries';
                break;
            case 3:
                subscriptionType = 'Filmes e Séries';
                break;
            default:
                subscriptionType = 'Desconhecido';
        }
        
        const expiresIn = new Date(userInfo.expirationDate);
        const daysLeft = Math.ceil((expiresIn - new Date()) / (1000 * 60 * 60 * 24));
        
        res.json({
            subscriptionType,
            daysLeft
        });
    } catch (error) {
        console.error('Erro ao obter informações do usuário:', error);
        res.status(500).json({ message: 'Erro ao obter informações do usuário', error: error.message });
    } finally {
        if (connection) connection.release();
    }
};

exports.getTutorials = async (req, res) => {
    try {
        const tutorials = [
            {
                title: 'Criar Usuário no seu Banco De Dados',
                content: `
                    <p>Siga estes passos para criar um novo usuário no seu banco de dados:</p>
                    <ol>
                        <li>Acesse sua máquina do XUI.ONE via terminal.</li>
                        <li>Execute o seguinte comando SQL:
                            <pre class="copyable-text">mysql -u root -p</pre>
                        </li>
                        <li>Agora execute esse para criar o usuario e senha:
                            <pre class="copyable-text">CREATE USER 'novo_usuario'@'%' IDENTIFIED BY 'senha_segura';</pre>
                        </li>
                        <li>Em seguida, conceda privilégios ao usuário:
                            <pre class="copyable-text">GRANT ALL PRIVILEGES ON *.* TO 'novo_usuario'@'%';</pre>
                        </li>
                        <li>Por fim, aplique as mudanças:
                            <pre class="copyable-text">FLUSH PRIVILEGES;</pre>
                        </li>
                    </ol>
                    <p>Lembre-se de substituir 'novo_usuario' e 'senha_segura' por valores apropriados.</p>
                `
            }
        ];
        res.json(tutorials);
    } catch (error) {
        console.error('Erro ao obter tutoriais:', error);
        res.status(500).json({ message: 'Erro ao obter tutoriais', error: error.message });
    }
};

exports.saveDbCredentials = async (req, res) => {
    const { username } = req.user;
    const { host, user, password } = req.body;
    let connection;

    try {
        // Teste a conexão
        const testConnection = await mysql.createConnection({
            host,
            user,
            password,
            database: 'xui'
        });

        const startTime = Date.now();
        await testConnection.query('SELECT 1');
        const endTime = Date.now();
        const responseTime = endTime - startTime;

        await testConnection.end();

        // Se chegou aqui, a conexão foi bem-sucedida
        connection = await configDbPool.getConnection();
        await connection.execute(
            'UPDATE user_configs SET dbHost = ?, dbUser = ?, dbPassword = ? WHERE username = ?',
            [host, user, password, username]
        );

        res.json({ success: true, message: 'Credenciais salvas com sucesso', responseTime });
    } catch (error) {
        console.error('Erro ao salvar credenciais do banco de dados:', error);
        res.status(400).json({ success: false, message: 'Não foi possível conectar ao banco de dados' });
    } finally {
        if (connection) connection.release();
    }
};

module.exports = {
    getSyncStatus: exports.getSyncStatus,
    getDbStatus: exports.getDbStatus,
    getUserInfo: exports.getUserInfo,
    getTutorials: exports.getTutorials,
    saveDbCredentials: exports.saveDbCredentials
};