const TelegramBot = require('node-telegram-bot-api');
const mysql = require('mysql2/promise');

const bot = new TelegramBot('7297261016:AAEvaxPHuzuLCkl_DX7B5wEGigBggLelUyc', {polling: true});

const configDbPool = mysql.createPool({
  host: 'localhost',
  user: 'sync',
  password: '26iaaHCz6mAswTpW',
  database: 'sync',
  connectionLimit: 5
});

const ADMIN_ID = '5560887634';
const userStates = {};

function isAdmin(msg) {
  return msg.from.id.toString() === ADMIN_ID;
}

bot.onText(/\/start/, (msg) => {
  if (isAdmin(msg)) {
    sendMainMenu(msg.chat.id);
  } else {
    bot.sendMessage(msg.chat.id, '❌ Desculpe, você não tem permissão para usar este bot.');
  }
});

function sendMainMenu(chatId) {
  const opts = {
    reply_markup: {
      inline_keyboard: [
        [{ text: '➕ Criar Usuário', callback_data: 'create_user' }],
        [{ text: '📋 Listar Usuários', callback_data: 'list_users' }]
      ]
    }
  };
  bot.sendMessage(chatId, '🎛️ Painel de Administração\nO que você gostaria de fazer?', opts);
}

bot.on('callback_query', async (callbackQuery) => {
  const chatId = callbackQuery.message.chat.id;
  const data = callbackQuery.data;

  if (!isAdmin({ from: { id: callbackQuery.from.id } })) return;

  switch (data) {
    case 'create_user':
      userStates[chatId] = { state: 'AWAITING_USERNAME' };
      bot.sendMessage(chatId, '👤 Por favor, digite o nome de usuário:');
      break;
    case 'list_users':
      await listUsers(chatId);
      break;
    case 'back_to_main':
      sendMainMenu(chatId);
      break;
    default:
      if (data.startsWith('edit_user_')) {
        const username = data.split('_')[2];
        showEditOptions(chatId, username);
      } else if (data.startsWith('delete_user_')) {
        const username = data.split('_')[2];
        await deleteUser(chatId, username);
      } else if (data.startsWith('edit_field_')) {
        const [, , username, field] = data.split('_');
        startFieldEdit(chatId, username, field);
      }
  }

  bot.answerCallbackQuery(callbackQuery.id);
});

async function listUsers(chatId) {
  try {
    const [rows] = await configDbPool.query('SELECT username FROM user_configs');
    const userButtons = rows.map(row => [{
      text: row.username,
      callback_data: `edit_user_${row.username}`
    }]);
    const opts = {
      reply_markup: {
        inline_keyboard: [
          ...userButtons,
          [{ text: '🔙 Voltar', callback_data: 'back_to_main' }]
        ]
      }
    };
    bot.sendMessage(chatId, '📊 Selecione um usuário para gerenciar:', opts);
  } catch (error) {
    console.error('Erro ao listar usuários:', error);
    bot.sendMessage(chatId, '❌ Ocorreu um erro ao listar os usuários.');
  }
}

function showEditOptions(chatId, username) {
  const opts = {
    reply_markup: {
      inline_keyboard: [
        [
          { text: '👤 Username', callback_data: `edit_field_${username}_username` },
          { text: '🔑 Senha', callback_data: `edit_field_${username}_password` }
        ],
        [
          { text: '🎭 Role', callback_data: `edit_field_${username}_role` },
          { text: '📅 Dias', callback_data: `edit_field_${username}_days` }
        ],
        [{ text: '🆔 Telegram ID', callback_data: `edit_field_${username}_telegramId` }],
        [{ text: '🗑️ Deletar Usuário', callback_data: `delete_user_${username}` }],
        [{ text: '🔙 Voltar', callback_data: 'list_users' }]
      ]
    }
  };
  bot.sendMessage(chatId, `👤 Editando usuário: ${username}\nSelecione um campo para editar:`, opts);
}

function startFieldEdit(chatId, username, field) {
  userStates[chatId] = { state: 'EDITING', username, field };
  let message;
  switch (field) {
    case 'username':
      message = '👤 Digite o novo nome de usuário:';
      break;
    case 'password':
      message = '🔑 Digite a nova senha:';
      break;
    case 'role':
      message = '🎭 Digite a nova role (1: Filmes, 2: Séries, 3: Filmes e Séries):';
      break;
    case 'days':
      message = '📅 Digite o novo número de dias de validade:';
      break;
    case 'telegramId':
      message = '🆔 Digite o novo Telegram ID (ou 0 para remover):';
      break;
  }
  bot.sendMessage(chatId, message);
}

async function deleteUser(chatId, username) {
  try {
    await configDbPool.query('DELETE FROM user_configs WHERE username = ?', [username]);
    bot.sendMessage(chatId, `✅ Usuário ${username} deletado com sucesso.`);
    await listUsers(chatId);
  } catch (error) {
    console.error('Erro ao deletar usuário:', error);
    bot.sendMessage(chatId, '❌ Ocorreu um erro ao deletar o usuário.');
  }
}

bot.on('message', async (msg) => {
  if (!isAdmin(msg)) return;

  const chatId = msg.chat.id;
  const messageText = msg.text;
  const state = userStates[chatId];

  if (state) {
    if (state.state === 'EDITING') {
      await handleFieldEdit(chatId, state.username, state.field, messageText);
    } else {
      await handleUserCreationFlow(chatId, messageText, state);
    }
  }
});

async function handleFieldEdit(chatId, username, field, value) {
  try {
    await updateUserField(chatId, username, field, value);
    delete userStates[chatId];
    showEditOptions(chatId, username);
  } catch (error) {
    console.error('Erro ao editar campo:', error);
    bot.sendMessage(chatId, '❌ Ocorreu um erro ao editar o campo. Tente novamente.');
  }
}

async function handleUserCreationFlow(chatId, messageText, state) {
  switch (state.state) {
    case 'AWAITING_USERNAME':
      userStates[chatId] = { ...state, state: 'AWAITING_PASSWORD', username: messageText };
      bot.sendMessage(chatId, '🔑 Agora, digite a senha:');
      break;
    case 'AWAITING_PASSWORD':
      userStates[chatId] = { ...state, state: 'AWAITING_ROLE', password: messageText };
      bot.sendMessage(chatId, '🎭 Escolha a role:\n1: Filmes\n2: Séries\n3: Filmes e Séries');
      break;
    case 'AWAITING_ROLE':
      if (['1', '2', '3'].includes(messageText)) {
        userStates[chatId] = { ...state, state: 'AWAITING_DAYS', role: parseInt(messageText) };
        bot.sendMessage(chatId, '📅 Quantos dias de validade?');
      } else {
        bot.sendMessage(chatId, '❌ Role inválida. Por favor, escolha 1, 2 ou 3.');
      }
      break;
    case 'AWAITING_DAYS':
      const days = parseInt(messageText);
      if (isNaN(days) || days <= 0) {
        bot.sendMessage(chatId, '❌ Por favor, insira um número válido de dias.');
      } else {
        userStates[chatId] = { ...state, state: 'AWAITING_TELEGRAM_ID', days: days };
        bot.sendMessage(chatId, '🆔 Digite o Telegram ID (opcional, envie 0 para pular):');
      }
      break;
    case 'AWAITING_TELEGRAM_ID':
      const telegramId = messageText !== '0' ? messageText : null;
      await createUser(chatId, { ...state, telegramId });
      delete userStates[chatId];
      break;
  }
}

async function createUser(chatId, userData) {
  try {
    const expirationDate = new Date();
    expirationDate.setDate(expirationDate.getDate() + userData.days);

    await configDbPool.query(
      'INSERT INTO user_configs (username, password, role, expirationDate, telegramId) VALUES (?, ?, ?, ?, ?)',
      [userData.username, userData.password, userData.role, expirationDate, userData.telegramId]
    );

    bot.sendMessage(chatId, `✅ Usuário ${userData.username} criado com sucesso!`);
    sendMainMenu(chatId);
  } catch (error) {
    console.error('Erro ao criar usuário:', error);
    bot.sendMessage(chatId, '❌ Ocorreu um erro ao criar o usuário. Verifique se o nome de usuário já existe.');
  }
}

async function updateUserField(chatId, username, field, value) {
  try {
    let query;
    let params;

    switch (field) {
      case 'username':
        query = 'UPDATE user_configs SET username = ? WHERE username = ?';
        params = [value, username];
        break;
      case 'password':
        query = 'UPDATE user_configs SET password = ? WHERE username = ?';
        params = [value, username];
        break;
      case 'role':
        if (!['1', '2', '3'].includes(value)) {
          throw new Error('Role inválida');
        }
        query = 'UPDATE user_configs SET role = ? WHERE username = ?';
        params = [parseInt(value), username];
        break;
      case 'days':
        const days = parseInt(value);
        if (isNaN(days) || days <= 0) {
          throw new Error('Número de dias inválido');
        }
        const expirationDate = new Date();
        expirationDate.setDate(expirationDate.getDate() + days);
        query = 'UPDATE user_configs SET expirationDate = ? WHERE username = ?';
        params = [expirationDate, username];
        break;
      case 'telegramId':
        query = 'UPDATE user_configs SET telegramId = ? WHERE username = ?';
        params = [value === '0' ? null : value, username];
        break;
      default:
        throw new Error('Campo inválido');
    }

    await configDbPool.query(query, params);
    bot.sendMessage(chatId, `✅ Campo ${field} atualizado com sucesso para o usuário ${username}.`);
  } catch (error) {
    console.error('Erro ao atualizar usuário:', error);
    throw error;
  }
}

console.log('🤖 Bot is running...');