import React from 'react';
import { Link, useNavigate } from 'react-router-dom';

const Navbar = () => {
  const navigate = useNavigate();
  const role = localStorage.getItem('role');

  const handleLogout = () => {
    localStorage.removeItem('token');
    localStorage.removeItem('role');
    navigate('/login');
  };

  return (
    <nav>
      <ul>
        {(role === '1' || role === '3') && <li><Link to="/movies">Filmes</Link></li>}
        {(role === '2' || role === '3') && <li><Link to="/series">Séries</Link></li>}
        <li><button onClick={handleLogout}>Sair</button></li>
      </ul>
    </nav>
  );
};

export default Navbar;