import React, { useState, useEffect } from 'react';
import { Link, Outlet, useNavigate, useLocation } from 'react-router-dom';
import { FaFilm, FaHome, FaTv, FaSignOutAlt, FaBars, FaUser, FaChevronRight, FaCircle } from 'react-icons/fa';

const Dashboard = () => {
  const [isSidebarOpen, setIsSidebarOpen] = useState(true);
  const [username, setUsername] = useState('');
  const [userRole, setUserRole] = useState('');
  const navigate = useNavigate();
  const location = useLocation();

  useEffect(() => {
    const storedUsername = localStorage.getItem('username');
    const storedRole = localStorage.getItem('role');
    
    if (storedUsername) {
      setUsername(storedUsername);
    }
    
    if (storedRole) {
      setUserRole(storedRole);
    }
  }, []);

  const handleLogout = () => {
    localStorage.removeItem('token');
    localStorage.removeItem('role');
    localStorage.removeItem('expiresIn');
    localStorage.removeItem('username');
    navigate('/login');
  };

  const toggleSidebar = () => {
    setIsSidebarOpen(!isSidebarOpen);
  };

  const menuItems = [
    { path: '/home', icon: <FaHome />, text: 'Página Inicial', roles: ['1', '2', '3'] },
    { path: '/movies', icon: <FaFilm />, text: 'Filmes', roles: ['1', '3'] },
    { path: '/series', icon: <FaTv />, text: 'Séries', roles: ['2', '3'] },
        { path: '/autosync', icon: <FaTv />, text: 'AutoSync', roles: ['2', '3'] },
  ];

  return (
    <div className={`dashboard ${isSidebarOpen ? 'sidebar-open' : 'sidebar-closed'}`}>
      <nav className="sidebar">
        <div className="sidebar-header">
          <div className="avatar">
            <FaUser />
          </div>
          {isSidebarOpen && (
            <div className="user-info">
              <h3>{username}</h3>
              <p className="online-status">
                <FaCircle className="online-icon" />
                <span>Online</span>
              </p>
            </div>
          )}
        </div>
        <ul className="sidebar-menu">
          {menuItems.map((item) => (
            item.roles.includes(userRole) && (
              <li key={item.path} className={location.pathname === item.path ? 'active' : ''}>
                <Link to={item.path}>
                  {item.icon}
                  <span>{item.text}</span>
                </Link>
              </li>
            )
          ))}
        </ul>
        <div className="sidebar-footer">
          <button onClick={handleLogout} className="logout-btn">
            <FaSignOutAlt />
            <span>Sair</span>
          </button>
        </div>
      </nav>
      <button className="sidebar-toggle" onClick={toggleSidebar}>
        {isSidebarOpen ? <FaBars /> : <FaChevronRight />}
      </button>
      <main className="content">
        <Outlet />
      </main>
    </div>
  );
};

export default Dashboard;