import React from 'react';
import { BrowserRouter as Router, Route, Routes, Navigate } from 'react-router-dom';
import { AuthProvider, useAuth } from './pages/AuthContext';
import LoginPage from './pages/LoginPage';
import Dashboard from './components/Dashboard';
import MoviePage from './pages/MoviePage';
import SeriesPage from './pages/SeriesPage';
import HomePage from './pages/HomePage';
import AutoSyncPage from './pages/autosyncpage';
import './App.css';

const ProtectedRoute = ({ children }) => {
  const { user, loading } = useAuth();
  
  if (loading) {
    return <div>Loading...</div>;
  }
  
  if (!user) {
    return <Navigate to="/login" replace />;
  }
  
  return children;
};

const App = () => {
  return (
    <AuthProvider>
      <Router>
        <Routes>
          <Route path="/login" element={<LoginPage />} />
          <Route 
            path="/" 
            element={
              <ProtectedRoute>
                <Dashboard />
              </ProtectedRoute>
            }
          >
            <Route path="home" element={<HomePage />} />
            <Route path="movies" element={<MoviePage />} />
            <Route path="series" element={<SeriesPage />} />
            <Route path="autosync" element={<AutoSyncPage />} />
            <Route index element={<Navigate to="home" />} />
          </Route>
        </Routes>
      </Router>
    </AuthProvider>
  );
};

export default App;