<?php
require_once 'includes/functions.php';

$message = '';
$messageType = '';

if ($_POST) {
    $imdb_id = sanitize($_POST['imdb_id']);
    $title = sanitize($_POST['title']);
    $year = (int)$_POST['year'];
    $type = sanitize($_POST['type']);
    $poster = sanitize($_POST['poster']);
    $requester_name = sanitize($_POST['requester_name']);
    $requester_email = sanitize($_POST['requester_email']);
    
    if (empty($title) || empty($requester_name) || empty($requester_email)) {
        $message = 'Por favor, preencha todos os campos obrigatórios.';
        $messageType = 'error';
    } else {
        if (addRequest($imdb_id, $title, $year, $type, $poster, $requester_name, $requester_email)) {
            $message = 'Solicitação enviada com sucesso! Você receberá uma resposta em breve.';
            $messageType = 'success';
        } else {
            $message = 'Erro ao enviar solicitação. Tente novamente.';
            $messageType = 'error';
        }
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Solicitação - MovieRequest Pro</title>
    <link rel="stylesheet" href="assets/css/style.css">
    <meta http-equiv="refresh" content="3;url=index.php">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <a href="index.php" class="logo">🎬 MovieRequest</a>
            <div class="nav-links">
                <a href="index.php">Início</a>
                <a href="search.php">Buscar</a>
                <a href="admin/index.php">Admin</a>
            </div>
        </nav>
    </header>

    <main class="container">
        <div class="hero">
            <?php if ($message): ?>
                <div class="alert alert-<?php echo $messageType; ?>">
                    <h2><?php echo $message; ?></h2>
                    <p>Você será redirecionado para a página inicial em 3 segundos...</p>
                    <a href="index.php" class="btn">🏠 Voltar ao Início</a>
                </div>
            <?php else: ?>
                <h1>Nenhuma solicitação recebida</h1>
                <a href="search.php" class="btn">🔍 Fazer uma Busca</a>
            <?php endif; ?>
        </div>
    </main>
</body>
</html>