<?php
require_once 'functions.php';

class OMDbAPI {
    private $api_key;
    private $base_url = 'http://www.omdbapi.com/';
    
    public function __construct() {
        $this->api_key = getSetting('omdb_api_key');
    }
    
    public function searchMovies($query, $type = null, $page = 1) {
        $params = [
            's' => $query,
            'apikey' => $this->api_key,
            'page' => $page
        ];
        
        if ($type && in_array($type, ['movie', 'series', 'episode'])) {
            $params['type'] = $type;
        }
        
        $url = $this->base_url . '?' . http_build_query($params);
        
        $response = $this->makeRequest($url);
        
        if ($response && $response['Response'] === 'True') {
            return $response;
        }
        
        return false;
    }
    
    public function getMovieDetails($imdb_id) {
        $params = [
            'i' => $imdb_id,
            'apikey' => $this->api_key,
            'plot' => 'full'
        ];
        
        $url = $this->base_url . '?' . http_build_query($params);
        
        $response = $this->makeRequest($url);
        
        if ($response && $response['Response'] === 'True') {
            return $response;
        }
        
        return false;
    }
    
    private function makeRequest($url) {
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_URL, $url);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_TIMEOUT, 10);
        
        $response = curl_exec($ch);
        curl_close($ch);
        
        if ($response) {
            return json_decode($response, true);
        }
        
        return false;
    }
}
?>