<?php
require_once __DIR__ . '/../config/database.php';

function sanitize($data) {
    return htmlspecialchars(trim($data), ENT_QUOTES, 'UTF-8');
}

function addRequest($imdb_id, $title, $year, $type, $poster, $requester_name, $requester_email) {
    $db = new Database();
    $pdo = $db->getConnection();
    
    $sql = "INSERT INTO requests (imdb_id, title, year, type, poster, requester_name, requester_email) 
            VALUES (?, ?, ?, ?, ?, ?, ?)";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$imdb_id, $title, $year, $type, $poster, $requester_name, $requester_email]);
        return true;
    } catch(PDOException $e) {
        return false;
    }
}

function getRequests($status = null) {
    $db = new Database();
    $pdo = $db->getConnection();
    
    if ($status) {
        $sql = "SELECT * FROM requests WHERE status = ? ORDER BY request_date DESC";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$status]);
    } else {
        $sql = "SELECT * FROM requests ORDER BY request_date DESC";
        $stmt = $pdo->query($sql);
    }
    
    return $stmt->fetchAll(PDO::FETCH_ASSOC);
}

function updateRequestStatus($id, $status, $notes = '') {
    $db = new Database();
    $pdo = $db->getConnection();
    
    $sql = "UPDATE requests SET status = ?, admin_notes = ? WHERE id = ?";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$status, $notes, $id]);
        return true;
    } catch(PDOException $e) {
        return false;
    }
}

function getSetting($key) {
    $db = new Database();
    $pdo = $db->getConnection();
    
    $sql = "SELECT value FROM settings WHERE key = ?";
    $stmt = $pdo->prepare($sql);
    $stmt->execute([$key]);
    $result = $stmt->fetch(PDO::FETCH_ASSOC);
    
    return $result ? $result['value'] : null;
}

function updateSetting($key, $value) {
    $db = new Database();
    $pdo = $db->getConnection();
    
    $sql = "INSERT OR REPLACE INTO settings (key, value) VALUES (?, ?)";
    
    try {
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$key, $value]);
        return true;
    } catch(PDOException $e) {
        return false;
    }
}
?>