<?php
class Database {
    private $dbFile;
    private $pdo;
    
    public function __construct() {
        $this->dbFile = __DIR__ . '/../pedidos.db';
        $this->connect();
        $this->createTables();
    }
    
    private function connect() {
        try {
            $this->pdo = new PDO("sqlite:" . $this->dbFile);
            $this->pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        } catch(PDOException $e) {
            die("Erro de conexão: " . $e->getMessage());
        }
    }
    
    private function createTables() {
        $sql = "
        CREATE TABLE IF NOT EXISTS requests (
            id INTEGER PRIMARY KEY AUTOINCREMENT,
            imdb_id TEXT,
            title TEXT NOT NULL,
            year INTEGER,
            type TEXT NOT NULL,
            poster TEXT,
            requester_name TEXT NOT NULL,
            requester_email TEXT NOT NULL,
            request_date DATETIME DEFAULT CURRENT_TIMESTAMP,
            status TEXT DEFAULT 'pendente',
            admin_notes TEXT
        );
        
        CREATE TABLE IF NOT EXISTS settings (
            key TEXT PRIMARY KEY,
            value TEXT
        );
        
        INSERT OR IGNORE INTO settings (key, value) VALUES ('omdb_api_key', 'SUA_CHAVE_API_AQUI');
        ";
        
        $this->pdo->exec($sql);
    }
    
    public function getConnection() {
        return $this->pdo;
    }
}
?>