// Função para mostrar loading
function showLoading() {
    document.querySelector('.loading').style.display = 'block';
}

function hideLoading() {
    document.querySelector('.loading').style.display = 'none';
}

// Função para fazer pedidos
function requestMovie(imdbId, title, year, type, poster) {
    const form = document.getElementById('request-form');
    if (form) {
        document.getElementById('movie-imdb-id').value = imdbId;
        document.getElementById('movie-title').value = title;
        document.getElementById('movie-year').value = year;
        document.getElementById('movie-type').value = type;
        document.getElementById('movie-poster').value = poster;
        
        // Scroll para o formulário
        form.scrollIntoView({ behavior: 'smooth' });
        
        // Highlight do formulário
        form.style.border = '2px solid #e50914';
        setTimeout(() => {
            form.style.border = 'none';
        }, 2000);
    }
}

// Validação de formulários
document.addEventListener('DOMContentLoaded', function() {
    const forms = document.querySelectorAll('form');
    
    forms.forEach(form => {
        form.addEventListener('submit', function(e) {
            const requiredFields = form.querySelectorAll('[required]');
            let isValid = true;
            
            requiredFields.forEach(field => {
                if (!field.value.trim()) {
                    isValid = false;
                    field.style.borderColor = '#dc3545';
                    
                    setTimeout(() => {
                        field.style.borderColor = '#444';
                    }, 3000);
                } else {
                    field.style.borderColor = '#28a745';
                    
                    setTimeout(() => {
                        field.style.borderColor = '#444';
                    }, 1000);
                }
            });
            
            if (!isValid) {
                e.preventDefault();
                showAlert('Por favor, preencha todos os campos obrigatórios.', 'error');
            }
        });
    });
});

// Função para mostrar alertas
function showAlert(message, type = 'info') {
    const alertDiv = document.createElement('div');
    alertDiv.className = `alert alert-${type}`;
    alertDiv.textContent = message;
    
    const container = document.querySelector('.container');
    container.insertBefore(alertDiv, container.firstChild);
    
    setTimeout(() => {
        alertDiv.remove();
    }, 5000);
}

// Filtros da tabela de administração
function filterTable(status) {
    const rows = document.querySelectorAll('.requests-table tbody tr');
    
    rows.forEach(row => {
        const statusCell = row.querySelector('.status-badge');
        if (status === 'all' || statusCell.textContent.toLowerCase() === status.toLowerCase()) {
            row.style.display = '';
        } else {
            row.style.display = 'none';
        }
    });
}

// Confirmação antes de alterar status
function confirmStatusChange(requestId, newStatus) {
    const message = `Tem certeza que deseja alterar o status para "${newStatus}"?`;
    
    if (confirm(message)) {
        const form = document.createElement('form');
        form.method = 'POST';
        form.style.display = 'none';
        
        const idInput = document.createElement('input');
        idInput.name = 'request_id';
        idInput.value = requestId;
        
        const statusInput = document.createElement('input');
        statusInput.name = 'new_status';
        statusInput.value = newStatus;
        
        form.appendChild(idInput);
        form.appendChild(statusInput);
        document.body.appendChild(form);
        form.submit();
    }
}

// Auto-refresh da página admin
if (window.location.pathname.includes('/admin/')) {
    setInterval(() => {
        // Refresh silencioso a cada 30 segundos
        fetch(window.location.href)
            .then(response => response.text())
            .then(html => {
                const parser = new DOMParser();
                const newDoc = parser.parseFromString(html, 'text/html');
                const newTable = newDoc.querySelector('.requests-table tbody');
                const currentTable = document.querySelector('.requests-table tbody');
                
                if (newTable && currentTable && newTable.innerHTML !== currentTable.innerHTML) {
                    currentTable.innerHTML = newTable.innerHTML;
                }
            })
            .catch(error => console.log('Refresh error:', error));
    }, 30000);
}