<?php
require_once '../includes/functions.php';

$message = '';
$messageType = '';

if ($_POST) {
    $omdb_api_key = sanitize($_POST['omdb_api_key']);
    
    if (updateSetting('omdb_api_key', $omdb_api_key)) {
        $message = 'Configurações atualizadas com sucesso!';
        $messageType = 'success';
    } else {
        $message = 'Erro ao atualizar configurações.';
        $messageType = 'error';
    }
}

$current_api_key = getSetting('omdb_api_key');
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Configurações - MovieRequest Pro</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <a href="../index.php" class="logo">🎬 MovieRequest</a>
            <div class="nav-links">
                <a href="../index.php">Site</a>
                <a href="index.php">Dashboard</a>
                <a href="requests.php">Solicitações</a>
                <a href="settings.php">Configurações</a>
            </div>
        </nav>
    </header>

    <main class="container">
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $messageType; ?>"><?php echo $message; ?></div>
        <?php endif; ?>

        <h1>⚙️ Configurações do Sistema</h1>

        <div class="admin-layout">
            <aside class="admin-sidebar">
                <h3>🔧 Configurações</h3>
                <nav>
                    <a href="#api-config" class="btn" style="width: 100%; margin-bottom: 1rem;">API OMDb</a>
                    <a href="#email-config" class="btn" style="width: 100%; margin-bottom: 1rem;">Email</a>
                    <a href="#system-info" class="btn" style="width: 100%; margin-bottom: 1rem;">Sistema</a>
                </nav>
            </aside>

            <div class="admin-content">
                <section id="api-config" class="config-section" style="background: var(--card-bg); padding: 2rem; border-radius: 15px; margin-bottom: 2rem;">
                    <h2>🔑 Configuração da API OMDb</h2>
                    <p>Para usar este sistema, você precisa de uma chave API do OMDb (gratuita).</p>
                    <p><a href="http://www.omdbapi.com/apikey.aspx" target="_blank" style="color: var(--accent-color);">🔗 Obter chave API gratuita</a></p>
                    
                    <form method="POST">
                        <div class="form-group">
                            <label for="omdb_api_key">Chave API OMDb:</label>
                            <input type="text" id="omdb_api_key" name="omdb_api_key" class="form-control" 
                                   value="<?php echo $current_api_key; ?>" 
                                   placeholder="Exemplo: 12345678" required>
                            <small style="color: #ccc;">Sua chave atual: <?php echo $current_api_key ? '✅ Configurada' : '❌ Não configurada'; ?></small>
                        </div>
                        <button type="submit" class="btn">💾 Salvar Configurações</button>
                    </form>
                </section>

                <section id="system-info" class="config-section" style="background: var(--card-bg); padding: 2rem; border-radius: 15px;">
                    <h2>📊 Informações do Sistema</h2>
                    <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 1rem;">
                        <div>
                            <strong>PHP Version:</strong><br>
                            <?php echo phpversion(); ?>
                        </div>
                        <div>
                            <strong>SQLite Version:</strong><br>
                            <?php 
                            $db = new Database();
                            $version = $db->getConnection()->query('SELECT sqlite_version()')->fetchColumn();
                            echo $version;
                            ?>
                        </div>
                        <div>
                            <strong>Base de Dados:</strong><br>
                            <?php echo file_exists(__DIR__ . '/../pedidos.db') ? '✅ Conectada' : '❌ Não encontrada'; ?>
                        </div>
                        <div>
                            <strong>Permissões:</strong><br>
                            <?php echo is_writable(__DIR__ . '/../pedidos.db') ? '✅ Escrita OK' : '❌ Sem permissão de escrita'; ?>
                        </div>
                    </div>

                    <h3 style="margin-top: 2rem;">🧪 Teste da API OMDb</h3>
                    <?php if ($current_api_key): ?>
                        <?php
                        require_once '../includes/omdb_api.php';
                        $omdb = new OMDbAPI();
                        $test_result = $omdb->searchMovies('batman', null, 1);
                        ?>
                        <p>Status da API: <?php echo $test_result ? '✅ Funcionando' : '❌ Erro na conexão'; ?></p>
                        <?php if ($test_result): ?>
                            <p>Teste realizado com sucesso! Encontrados <?php echo $test_result['totalResults']; ?> resultados para "batman".</p>
                        <?php endif; ?>
                    <?php else: ?>
                        <p>❌ Configure a chave API para testar a conexão.</p>
                    <?php endif; ?>
                </section>
            </div>
        </div>
    </main>

    <script src="../assets/js/script.js"></script>
</body>
</html>