<?php
require_once 'includes/functions.php';
require_once 'includes/omdb_api.php';

$omdb = new OMDbAPI();
$results = null;
$error = null;

if (isset($_GET['query']) && !empty($_GET['query'])) {
    $query = sanitize($_GET['query']);
    $type = isset($_GET['type']) ? sanitize($_GET['type']) : null;
    $page = isset($_GET['page']) ? (int)$_GET['page'] : 1;
    
    $results = $omdb->searchMovies($query, $type, $page);
    
    if (!$results) {
        $error = "Nenhum resultado encontrado para '$query'.";
    }
}
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Buscar - MovieRequest Pro</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <a href="index.php" class="logo">🎬 MovieRequest</a>
            <div class="nav-links">
                <a href="index.php">Início</a>
                <a href="search.php">Buscar</a>
                <a href="admin/index.php">Admin</a>
            </div>
        </nav>
    </header>

    <main class="container">
        <section class="search-form">
            <h1>🔍 Buscar Filmes e Séries</h1>
            <form method="GET">
                <div class="form-row">
                    <div class="form-group">
                        <label for="query">Título:</label>
                        <input type="text" id="query" name="query" class="form-control" 
                               value="<?php echo isset($_GET['query']) ? sanitize($_GET['query']) : ''; ?>" required>
                    </div>
                    <div class="form-group">
                        <label for="type">Tipo:</label>
                        <select id="type" name="type" class="form-control">
                            <option value="">Todos</option>
                            <option value="movie" <?php echo (isset($_GET['type']) && $_GET['type'] === 'movie') ? 'selected' : ''; ?>>Filme</option>
                            <option value="series" <?php echo (isset($_GET['type']) && $_GET['type'] === 'series') ? 'selected' : ''; ?>>Série</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn">🔍 Buscar</button>
            </form>
        </section>

        <div class="loading">
            <div class="spinner"></div>
            <p>Buscando...</p>
        </div>

        <?php if ($error): ?>
            <div class="alert alert-error"><?php echo $error; ?></div>
        <?php endif; ?>

        <?php if ($results && isset($results['Search'])): ?>
            <section class="search-results">
                <h2>📊 Resultados da Busca</h2>
                <p>Encontrados <?php echo $results['totalResults']; ?> resultados</p>
                
                <div class="movie-grid">
                    <?php foreach ($results['Search'] as $movie): ?>
                        <?php
                        $poster = $movie['Poster'] && $movie['Poster'] !== 'N/A' 
                            ? $movie['Poster'] 
                            : 'https://via.placeholder.com/300x450?text=Sem+Poster';
                        ?>
                        <div class="movie-card">
                            <img src="<?php echo $poster; ?>" alt="<?php echo sanitize($movie['Title']); ?>" class="movie-poster">
                            <div class="movie-info">
                                <div class="movie-title"><?php echo sanitize($movie['Title']); ?></div>
                                <div class="movie-year"><?php echo sanitize($movie['Year']); ?></div>
                                <span class="movie-type"><?php echo ucfirst($movie['Type']); ?></span>
                                <br><br>
                                <button class="btn" onclick="requestMovie('<?php echo $movie['imdbID']; ?>', '<?php echo addslashes($movie['Title']); ?>', '<?php echo $movie['Year']; ?>', '<?php echo $movie['Type']; ?>', '<?php echo addslashes($poster); ?>')">
                                    📝 Solicitar
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>

                <?php if ($results['totalResults'] > 10): ?>
                    <div class="pagination">
                        <?php
                        $total_pages = ceil($results['totalResults'] / 10);
                        $current_page = $page;
                        
                        for ($i = max(1, $current_page - 2); $i <= min($total_pages, $current_page + 2); $i++):
                        ?>
                            <a href="?query=<?php echo urlencode($_GET['query']); ?>&type=<?php echo urlencode($_GET['type'] ?? ''); ?>&page=<?php echo $i; ?>" 
                               class="btn <?php echo $i == $current_page ? 'btn-secondary' : ''; ?>">
                                <?php echo $i; ?>
                            </a>
                        <?php endfor; ?>
                    </div>
                <?php endif; ?>
            </section>
        <?php endif; ?>

        <!-- Formulário de Solicitação -->
        <section class="request-form" id="request-form" style="display: none;">
            <h2>📝 Solicitar Filme/Série</h2>
            <form action="request.php" method="POST">
                <input type="hidden" id="movie-imdb-id" name="imdb_id">
                <input type="hidden" id="movie-title" name="title">
                <input type="hidden" id="movie-year" name="year">
                <input type="hidden" id="movie-type" name="type">
                <input type="hidden" id="movie-poster" name="poster">
                
                <div class="form-row">
                    <div class="form-group">
                        <label for="requester_name">Seu Nome:</label>
                        <input type="text" id="requester_name" name="requester_name" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="requester_email">Seu Email:</label>
                        <input type="email" id="requester_email" name="requester_email" class="form-control" required>
                    </div>
                </div>
                
                <button type="submit" class="btn">✅ Enviar Solicitação</button>
                <button type="button" class="btn btn-secondary" onclick="hideRequestForm()">❌ Cancelar</button>
            </form>
        </section>
    </main>

    <script src="assets/js/script.js"></script>
    <script>
        function requestMovie(imdbId, title, year, type, poster) {
            document.getElementById('movie-imdb-id').value = imdbId;
            document.getElementById('movie-title').value = title;
            document.getElementById('movie-year').value = year;
            document.getElementById('movie-type').value = type;
            document.getElementById('movie-poster').value = poster;
            
            const form = document.getElementById('request-form');
            form.style.display = 'block';
            form.scrollIntoView({ behavior: 'smooth' });
        }
        
        function hideRequestForm() {
            document.getElementById('request-form').style.display = 'none';
        }
    </script>
</body>
</html>