<?php
require_once 'includes/functions.php';
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>MovieRequest Pro - Solicite Filmes e Séries</title>
    <link rel="stylesheet" href="assets/css/style.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <a href="index.php" class="logo">🎬 MovieRequest</a>
            <div class="nav-links">
                <a href="index.php">Início</a>
                <a href="search.php">Buscar</a>
                <a href="admin/index.php">Admin</a>
            </div>
        </nav>
    </header>

    <main class="container">
        <section class="hero">
            <h1>Solicite seus Filmes e Séries Favoritos</h1>
            <p>Encontre e solicite filmes e séries através da nossa plataforma integrada com IMDB</p>
        </section>

        <section class="search-form">
            <h2>🔍 Buscar Filmes e Séries</h2>
            <form action="search.php" method="GET">
                <div class="form-row">
                    <div class="form-group">
                        <label for="query">Título:</label>
                        <input type="text" id="query" name="query" class="form-control" required>
                    </div>
                    <div class="form-group">
                        <label for="type">Tipo:</label>
                        <select id="type" name="type" class="form-control">
                            <option value="">Todos</option>
                            <option value="movie">Filme</option>
                            <option value="series">Série</option>
                        </select>
                    </div>
                </div>
                <button type="submit" class="btn">🔍 Buscar</button>
            </form>
        </section>

        <section class="recent-requests">
            <h2>📋 Últimos Pedidos</h2>
            <?php
            $recent_requests = getRequests();
            $recent_requests = array_slice($recent_requests, 0, 6);
            
            if (empty($recent_requests)) {
                echo "<p>Nenhum pedido realizado ainda.</p>";
            } else {
                echo '<div class="movie-grid">';
                foreach ($recent_requests as $request) {
                    $poster = $request['poster'] && $request['poster'] !== 'N/A' 
                        ? $request['poster'] 
                        : 'https://via.placeholder.com/300x450?text=Sem+Poster';
                    
                    echo "
                    <div class='movie-card'>
                        <img src='{$poster}' alt='{$request['title']}' class='movie-poster'>
                        <div class='movie-info'>
                            <div class='movie-title'>" . sanitize($request['title']) . "</div>
                            <div class='movie-year'>" . ($request['year'] ?: 'Ano desconhecido') . "</div>
                            <span class='movie-type'>" . ucfirst($request['type']) . "</span>
                            <span class='status-badge status-" . $request['status'] . "'>" . ucfirst($request['status']) . "</span>
                        </div>
                    </div>";
                }
                echo '</div>';
            }
            ?>
        </section>
    </main>

    <script src="assets/js/script.js"></script>
</body>
</html>