<?php
require_once '../includes/functions.php';

$message = '';
$messageType = '';

// Processar alterações de status
if ($_POST && isset($_POST['request_id']) && isset($_POST['new_status'])) {
    $request_id = (int)$_POST['request_id'];
    $new_status = sanitize($_POST['new_status']);
    $admin_notes = sanitize($_POST['admin_notes'] ?? '');
    
    if (updateRequestStatus($request_id, $new_status, $admin_notes)) {
        $message = 'Status atualizado com sucesso!';
        $messageType = 'success';
    } else {
        $message = 'Erro ao atualizar status.';
        $messageType = 'error';
    }
}

// Filtros
$filter_status = isset($_GET['status']) ? sanitize($_GET['status']) : null;
$requests = $filter_status ? getRequests($filter_status) : getRequests();
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Gerenciar Solicitações - MovieRequest Pro</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <a href="../index.php" class="logo">🎬 MovieRequest</a>
            <div class="nav-links">
                <a href="../index.php">Site</a>
                <a href="index.php">Dashboard</a>
                <a href="requests.php">Solicitações</a>
                <a href="settings.php">Configurações</a>
            </div>
        </nav>
    </header>

    <main class="container">
        <?php if ($message): ?>
            <div class="alert alert-<?php echo $messageType; ?>"><?php echo $message; ?></div>
        <?php endif; ?>

        <h1>📋 Gerenciar Solicitações</h1>

        <div class="filters" style="background: var(--card-bg); padding: 1rem; border-radius: 10px; margin-bottom: 2rem;">
            <h3>🔍 Filtros:</h3>
            <a href="requests.php" class="btn <?php echo !$filter_status ? 'btn-secondary' : ''; ?>">Todas</a>
            <a href="requests.php?status=pendente" class="btn <?php echo $filter_status === 'pendente' ? 'btn-secondary' : ''; ?>">Pendentes</a>
            <a href="requests.php?status=aprovado" class="btn <?php echo $filter_status === 'aprovado' ? 'btn-secondary' : ''; ?>">Aprovadas</a>
            <a href="requests.php?status=rejeitado" class="btn <?php echo $filter_status === 'rejeitado' ? 'btn-secondary' : ''; ?>">Rejeitadas</a>
        </div>

        <?php if (empty($requests)): ?>
            <div class="alert alert-info">Nenhuma solicitação encontrada.</div>
        <?php else: ?>
            <div style="overflow-x: auto;">
                <table class="requests-table">
                    <thead>
                        <tr>
                            <th>Poster</th>
                            <th>Título</th>
                            <th>Ano</th>
                            <th>Tipo</th>
                            <th>Solicitante</th>
                            <th>Email</th>
                            <th>Data</th>
                            <th>Status</th>
                            <th>Ações</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($requests as $request): ?>
                            <tr>
                                <td>
                                    <img src="<?php echo $request['poster'] && $request['poster'] !== 'N/A' ? $request['poster'] : 'https://via.placeholder.com/50x75?text=Sem+Poster'; ?>" 
                                         alt="<?php echo sanitize($request['title']); ?>" 
                                         style="width: 50px; height: 75px; object-fit: cover; border-radius: 5px;">
                                </td>
                                <td><strong><?php echo sanitize($request['title']); ?></strong></td>
                                <td><?php echo $request['year'] ?: 'N/A'; ?></td>
                                <td><span class="movie-type"><?php echo ucfirst($request['type']); ?></span></td>
                                <td><?php echo sanitize($request['requester_name']); ?></td>
                                <td><a href="mailto:<?php echo $request['requester_email']; ?>"><?php echo sanitize($request['requester_email']); ?></a></td>
                                <td><?php echo date('d/m/Y H:i', strtotime($request['request_date'])); ?></td>
                                <td><span class="status-badge status-<?php echo $request['status']; ?>"><?php echo ucfirst($request['status']); ?></span></td>
                                <td>
                                    <div style="display: flex; gap: 0.5rem; flex-wrap: wrap;">
                                        <?php if ($request['status'] !== 'aprovado'): ?>
                                            <form method="POST" style="display: inline;">
                                                <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                                                <input type="hidden" name="new_status" value="aprovado">
                                                <button type="submit" class="btn" style="background: #28a745; padding: 0.25rem 0.5rem; font-size: 0.8rem;">✅</button>
                                            </form>
                                        <?php endif; ?>
                                        
                                        <?php if ($request['status'] !== 'rejeitado'): ?>
                                            <form method="POST" style="display: inline;">
                                                <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                                                <input type="hidden" name="new_status" value="rejeitado">
                                                <button type="submit" class="btn" style="background: #dc3545; padding: 0.25rem 0.5rem; font-size: 0.8rem;">❌</button>
                                            </form>
                                        <?php endif; ?>
                                        
                                        <?php if ($request['status'] !== 'pendente'): ?>
                                            <form method="POST" style="display: inline;">
                                                <input type="hidden" name="request_id" value="<?php echo $request['id']; ?>">
                                                <input type="hidden" name="new_status" value="pendente">
                                                <button type="submit" class="btn" style="background: #ffc107; color: #000; padding: 0.25rem 0.5rem; font-size: 0.8rem;">⏳</button>
                                            </form>
                                        <?php endif; ?>
                                    </div>
                                    
                                    <?php if ($request['admin_notes']): ?>
                                        <div style="margin-top: 0.5rem; font-size: 0.8rem; color: #ccc;">
                                            <strong>Notas:</strong> <?php echo sanitize($request['admin_notes']); ?>
                                        </div>
                                    <?php endif; ?>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
    </main>

    <script src="../assets/js/script.js"></script>
</body>
</html>