<?php
require_once '../includes/functions.php';

// Estatísticas
$total_requests = count(getRequests());
$pending_requests = count(getRequests('pendente'));
$approved_requests = count(getRequests('aprovado'));
$rejected_requests = count(getRequests('rejeitado'));
?>
<!DOCTYPE html>
<html lang="pt-BR">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin - MovieRequest Pro</title>
    <link rel="stylesheet" href="../assets/css/style.css">
</head>
<body>
    <header class="header">
        <nav class="nav">
            <a href="../index.php" class="logo">🎬 MovieRequest</a>
            <div class="nav-links">
                <a href="../index.php">Site</a>
                <a href="index.php">Dashboard</a>
                <a href="requests.php">Solicitações</a>
                <a href="settings.php">Configurações</a>
            </div>
        </nav>
    </header>

    <main class="container">
        <h1>🎯 Painel Administrativo</h1>
        
        <div class="admin-layout">
            <aside class="admin-sidebar">
                <h3>📊 Menu</h3>
                <nav>
                    <a href="index.php" class="btn" style="width: 100%; margin-bottom: 1rem;">Dashboard</a>
                    <a href="requests.php" class="btn" style="width: 100%; margin-bottom: 1rem;">Solicitações</a>
                    <a href="settings.php" class="btn" style="width: 100%; margin-bottom: 1rem;">Configurações</a>
                </nav>
            </aside>

            <div class="admin-content">
                <div class="stats-grid" style="display: grid; grid-template-columns: repeat(auto-fit, minmax(200px, 1fr)); gap: 2rem; margin-bottom: 2rem;">
                    <div class="stat-card" style="background: var(--card-bg); padding: 2rem; border-radius: 15px; text-align: center;">
                        <h3 style="color: var(--accent-color);">📊 Total</h3>
                        <div style="font-size: 3rem; font-weight: bold; color: var(--primary-color);"><?php echo $total_requests; ?></div>
                        <p>Solicitações</p>
                    </div>
                    
                    <div class="stat-card" style="background: var(--card-bg); padding: 2rem; border-radius: 15px; text-align: center;">
                        <h3 style="color: #ffc107;">⏳ Pendentes</h3>
                        <div style="font-size: 3rem; font-weight: bold; color: #ffc107;"><?php echo $pending_requests; ?></div>
                        <p>Aguardando</p>
                    </div>
                    
                    <div class="stat-card" style="background: var(--card-bg); padding: 2rem; border-radius: 15px; text-align: center;">
                        <h3 style="color: #28a745;">✅ Aprovadas</h3>
                        <div style="font-size: 3rem; font-weight: bold; color: #28a745;"><?php echo $approved_requests; ?></div>
                        <p>Concluídas</p>
                    </div>
                    
                    <div class="stat-card" style="background: var(--card-bg); padding: 2rem; border-radius: 15px; text-align: center;">
                        <h3 style="color: #dc3545;">❌ Rejeitadas</h3>
                        <div style="font-size: 3rem; font-weight: bold; color: #dc3545;"><?php echo $rejected_requests; ?></div>
                        <p>Recusadas</p>
                    </div>
                </div>

                <div class="recent-activity" style="background: var(--card-bg); padding: 2rem; border-radius: 15px;">
                    <h2>🕐 Atividade Recente</h2>
                    <?php
                    $recent_requests = array_slice(getRequests(), 0, 5);
                    
                    if (empty($recent_requests)) {
                        echo "<p>Nenhuma atividade recente.</p>";
                    } else {
                        echo "<div class='activity-list'>";
                        foreach ($recent_requests as $request) {
                            $time_ago = date('d/m/Y H:i', strtotime($request['request_date']));
                            echo "
                            <div style='display: flex; justify-content: space-between; align-items: center; padding: 1rem 0; border-bottom: 1px solid #444;'>
                                <div>
                                    <strong>" . sanitize($request['title']) . "</strong><br>
                                    <small>Por: " . sanitize($request['requester_name']) . " - $time_ago</small>
                                </div>
                                <span class='status-badge status-" . $request['status'] . "'>" . ucfirst($request['status']) . "</span>
                            </div>";
                        }
                        echo "</div>";
                    }
                    ?>
                    <a href="requests.php" class="btn" style="margin-top: 1rem;">Ver Todas as Solicitações</a>
                </div>
            </div>
        </div>
    </main>

    <script src="../assets/js/script.js"></script>
</body>
</html>