<?php
include_once "../../config.php";

$keyall_tmdb = $key_tmdb;

?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Full-Screen Movie Banner</title>
    
    <style>
        body {
            margin: 0;
            padding: 0;
        }

        .overlay {
            position: absolute;
            border-radius: 5px;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background-size: 100% 100%;
        }

        .movie-info {
            position: fixed;
            top: 4.5vw;
            left: 1%;
            display: flex;
            align-items: center;
            justify-content: center;
            text-transform: uppercase;
            color: white;
            font-size: 3.5vw;
        }

        .subtitial-info {
            position: fixed;
            top: 11.8vw;
            left: 1%;
            display: flex;
            align-items: center;
            justify-content: center;
            text-transform: uppercase;
            color: white;
            font-size: 1.1vw;
        }
        
        .info-container {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            display: flex;
            background: linear-gradient(to right, rgba(0, 0, 0, 1), rgba(0, 0, 0, 0));
            flex-direction: column;
            border-radius: 4px;
            align-items: center;
            justify-content: center;
        }
    </style>
</head>
<body>
    <div class="overlay" id="viewport_capture">
        <div class="info-container">
            <h1 id="movie-title" class="movie-info"></h1>
            <p id="msubtitial" class="subtitial-info"></p>
        </div>
    </div>
    
    <script>
        const apiKey = '<?= $keyall_tmdb; ?>';
        let currentIndex = 0;
        let currentPage = 1;
        let totalPageCount = 15;
        let movieIds = [];
        let nextImage = null;

        async function fetchPopularMovieIds() {
            while (currentPage <= totalPageCount) {
                try {
                    const response = await fetch(`https://api.themoviedb.org/3/discover/movie?api_key=${apiKey}&page=${currentPage}&sort_by=popularity.desc&language=pt-BR`);
                    const data = await response.json();
                    movieIds = [...movieIds, ...data.results.map(movie => movie.id)];
                    currentPage++; 
                } catch (error) {
                    console.error(error);
                    break; 
                }
            }
        }

        function preloadNextImage() {
            if (movieIds.length === 0) {
                console.error('Failed to get movie IDs.');
                return;
            }

            const nextIndex = (currentIndex + 1) % movieIds.length;
            const nextMovieId = movieIds[nextIndex];

            fetch(`https://api.themoviedb.org/3/movie/${nextMovieId}?api_key=${apiKey}&language=pt-BR`)
                .then((response) => response.json())
                .then((data) => {
                    nextImage = new Image();
                    nextImage.src = `https://image.tmdb.org/t/p/original${data.backdrop_path}`;
                })
                .catch((error) => console.error(error));
        }

        async function updateMovieInfo() {
    if (movieIds.length === 0) {
        console.error('Failed to get movie IDs.');
        return;
    }

    const movieId = movieIds[currentIndex];

    fetch(`https://api.themoviedb.org/3/movie/${movieId}?api_key=${apiKey}&language=pt-BR`)
        .then((response) => response.json())
        .then((data) => {
            const posterPath = `https://image.tmdb.org/t/p/original${data.backdrop_path}`;
            document.querySelector('.overlay').style.backgroundImage = `url('${posterPath}')`;

            setTimeout(() => {
                preloadNextImage();
                const movieTitle = document.getElementById('movie-title');
                const mcategory = document.getElementById('msubtitial');
                
                const releaseDate = data.release_date;
                const releaseYear = new Date(releaseDate).getFullYear();
                const maintital = data.title + ` (${releaseYear})`;
                
                movieTitle.innerText = maintital;

                const formattedReleaseDate = new Date(releaseDate).toLocaleDateString('pt-BR');
                const genresArray = data.genres.map(genre => `🎬 ${genre.name}`).join(' ');
                const duration = data.runtime;
                const hours = Math.floor(duration / 60) + 'h';
                const minutes = duration % 60 + 'm';
                const fullSubtitial = ` 📀 ` + formattedReleaseDate + ` | ` + genresArray + ` | ` + '🕝 ' + hours + ' ' + minutes;
                mcategory.innerText = fullSubtitial;
            }, 200);

            currentIndex = (currentIndex + 1) % movieIds.length;
            preloadNextImage();
        })
        .catch((error) => console.error(error));
}

        fetchPopularMovieIds().then(() => {
            preloadNextImage();
            setTimeout(updateMovieInfo, 0);
            setInterval(updateMovieInfo, 12000);
        });
    </script>
</body>
</html>