export const MAX_LAYOUT_PERMITTED = 5;

export const AppLayoutDefault = [
  {
    label: 'Nome do app',
    name: 'APP_NAME',
    status: 'ACTIVE',
    type: 'STRING',
    value: 'DTunnel Mod',
  },
  {
    label: 'Logo do app',
    name: 'APP_LOGO',
    status: 'ACTIVE',
    type: 'IMAGE',
    value: null,
  },
  {
    label: 'Imagem de fundo',
    name: 'APP_BACKGROUND_IMAGE',
    status: 'ACTIVE',
    type: 'IMAGE',
    value: null,
  },
  {
    label: 'Tipo do fundo do app',
    name: 'APP_BACKGROUND_TYPE',
    status: 'ACTIVE',
    type: 'SELECT',
    value: {
      options: [
        {
          label: 'Imagem',
          value: 'IMAGE',
        },
        {
          label: 'Cor',
          value: 'COLOR',
        },
      ],
      selected: 'COLOR',
    },
  },
  {
    label: 'Cor de fundo',
    name: 'APP_BACKGROUND_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#080e16c7',
  },
  {
    label: 'Cor do card inicial',
    name: 'APP_CARD_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#1d242e73',
  },
  {
    label: 'Raio do card inicial',
    name: 'APP_CARD_RADIUS',
    status: 'ACTIVE',
    type: 'INTEGER',
    value: 20,
  },
  {
    label: 'Cor do card de status',
    name: 'APP_CARD_STATUS_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#1d242e73',
  },
  {
    label: 'Raio do card de status',
    name: 'APP_CARD_STATUS_RADIUS',
    status: 'ACTIVE',
    type: 'INTEGER',
    value: 25,
  },
  {
    label: 'Cor do card de configurações',
    name: 'APP_CARD_CONFIG_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#0E171EC9',
  },
  {
    label: 'Cor do fundo dos dialogs',
    name: 'APP_DIALOG_BACKGROUND_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#050C5AE4',
  },
  {
    label: 'Cor do fundo do dialog de log',
    name: 'APP_DIALOG_LOGGER_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#080e16c7',
  },
  {
    label: 'Cor das bordas',
    name: 'APP_BORDER_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#1d242e73',
  },
  {
    label: 'Cor dos inputs',
    name: 'APP_INPUT_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#1d242e73',
  },
  {
    label: 'Raio dos inputs',
    name: 'APP_INPUT_RADIUS',
    status: 'ACTIVE',
    type: 'INTEGER',
    value: 25,
  },
  {
    label: 'Cor dos textos',
    name: 'APP_TEXT_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#FFFFFFFF',
  },
  {
    label: 'Cor dos botões',
    name: 'APP_BUTTON_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#1d242e73',
  },
  {
    label: 'Raio dos botões',
    name: 'APP_BUTTON_RADIUS',
    status: 'ACTIVE',
    type: 'INTEGER',
    value: 25,
  },
  {
    label: 'Cor dos icones',
    name: 'APP_ICON_COLOR',
    status: 'ACTIVE',
    type: 'COLOR',
    value: '#FFFFFFFF',
  },
  {
    label: 'Exibir modo de conexão',
    name: 'APP_SHOW_CONNECTION_MODE',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Atualizar automaticamente as configurações ao lançar uma atualização.',
    name: 'APP_CONFIG_AUTO_UPDATE',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: false,
  },
  {
    label: 'Iniciar o app automaticamente ao reiniciar o dispositivo',
    name: 'APP_AUTO_START',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: false,
  },
  {
    label: 'Usar limiter de conexão',
    name: 'APP_CONNECTION_LIMITER',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: false,
  },
  {
    label: 'Usar botão de atualizações',
    name: 'APP_BTN_UPDATE_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Usar botão de registros',
    name: 'APP_BTN_LOGGER_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Usar botão de pagina webview',
    name: 'APP_BTN_PAGE_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Ativar dialog de erros',
    name: 'APP_DIALOG_ERROR_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Ativar dialog de checkuser',
    name: 'APP_CHECKUSER_DIALOG_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Ativar toast de sucesso',
    name: 'APP_SUCCESS_TOAST_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Ativar toast de erro',
    name: 'APP_ERROR_TOAST_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: true,
  },
  {
    label: 'Usar layout webview',
    name: 'APP_LAYOUT_WEBVIEW_ENABLED',
    status: 'ACTIVE',
    type: 'BOOLEAN',
    value: false,
  },
  {
    label: 'Mensagem',
    name: 'APP_MESSAGE',
    status: 'ACTIVE',
    type: 'TEXT',
    value: null,
  },
  {
    label: 'Tipo de mensagem',
    name: 'APP_MESSAGE_TYPE',
    status: 'ACTIVE',
    type: 'SELECT',
    value: {
      options: [
        {
          label: 'Alerta',
          value: 'ALERT',
        },
        {
          label: 'Informação',
          value: 'INFO',
        },
        {
          label: 'Boas vindas',
          value: 'WELCOME',
        },
        {
          label: 'Sem mensagem',
          value: 'NONE',
        },
      ],
      selected: 'NONE',
    },
  },
  {
    label: 'URL de atualização do aplicativo',
    name: 'APP_UPDATE_URL',
    status: 'ACTIVE',
    type: 'URL',
    value: null,
  },
  {
    label: 'LAYOUT WEBVIEW (POR SUA CONTA E RISCO)',
    name: 'APP_LAYOUT_WEBVIEW',
    status: 'ACTIVE',
    type: 'HTML',
    value: null,
  },
  {
    label: 'ANDROID WEBVIEW (POR SUA CONTA E RISCO)',
    name: 'APP_SUPPORT_BUTTON',
    status: 'ACTIVE',
    type: 'HTML',
    value: null,
  },
  {
    label: 'PAGINA WEBVIEW (POR SUA CONTA E RISCO)',
    name: 'APP_WEB_VIEW',
    status: 'ACTIVE',
    type: 'HTML',
    value: null,
  },
];
